"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FaqService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const faq_item_entity_1 = require("./faq-item.entity");
let FaqService = class FaqService {
    repo;
    constructor(repo) {
        this.repo = repo;
    }
    findAll() {
        return this.repo.find({ order: { order: 'ASC' } });
    }
    async findOne(id) {
        const item = await this.repo.findOneBy({ id });
        if (!item)
            throw new common_1.NotFoundException(`FAQ #${id} not found`);
        return item;
    }
    async create(dto) {
        if (dto.order === undefined) {
            const max = await this.repo
                .createQueryBuilder('f')
                .select('MAX(f.order)', 'maxOrder')
                .getRawOne();
            dto.order = (max?.maxOrder ?? -1) + 1;
        }
        const normalized = this.normalizeDto(dto);
        const item = this.repo.create(normalized);
        return this.repo.save(item);
    }
    async update(id, dto) {
        const item = await this.findOne(id);
        const normalized = this.normalizeDto(dto);
        Object.assign(item, normalized);
        return this.repo.save(item);
    }
    async remove(id) {
        const item = await this.findOne(id);
        return this.repo.remove(item);
    }
    async reorder(ids) {
        const updates = ids.map((id, index) => this.repo.update(id, { order: index }));
        await Promise.all(updates);
        return this.findAll();
    }
    normalizeDto(dto) {
        const normalized = { ...dto };
        const questionRu = dto.questionRu ?? dto.question;
        const answerRu = dto.answerRu ?? dto.answer;
        if (questionRu) {
            normalized.questionRu = questionRu;
        }
        if (answerRu) {
            normalized.answerRu = answerRu;
        }
        if (!dto.question && questionRu) {
            normalized.question = questionRu;
        }
        if (!dto.answer && answerRu) {
            normalized.answer = answerRu;
        }
        return normalized;
    }
};
exports.FaqService = FaqService;
exports.FaqService = FaqService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(faq_item_entity_1.FaqItem)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], FaqService);
//# sourceMappingURL=faq.service.js.map